package cn.com.duiba.quanyi.center.api.param.deposit;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 保证金外部发票关联表查询参数
 * @author xuzhigang
 * @date 2025-01-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class PaymentInfoDepositInvoiceRefSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 主键ID集合
     */
    private List<Long> ids;

    /**
     * 保证金id tb_demand_paymnet_info.id
     */
    private Long paymentInfoId;

    /**
     * 保证金id集合
     */
    private List<Long> paymentInfoIds;

    /**
     * 外部发票id
     */
    private Long invoiceExternalId;

    /**
     * 外部发票id集合
     */
    private List<Long> invoiceExternalIds;

    /**
     * 创建时间开始
     */
    private Date gmtCreateStart;

    /**
     * 创建时间结束
     */
    private Date gmtCreateEnd;
}
