package cn.com.duiba.quanyi.center.api.remoteservice.ccb.billpush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccb.billpush.CcbBillPushTaskDto;
import cn.com.duiba.quanyi.center.api.param.ccb.billpush.CcbBillPushTaskPageParam;

import java.util.List;

/**
 * 建行账单推送任务 RemoteService。
 *
 * <p>提供新增、更新、按ID查询、分页查询等能力。</p>
 *
 * @author zzy
 * @since 2025-09-25 10:30
 */
@AdvancedFeignClient
public interface RemoteCcbBillPushTaskService {

    /**
     * 新增
     *
     * @param dto 任务
     * @return 新增记录主键
     */
    Long insert(CcbBillPushTaskDto dto);

    /**
     * 更新
     *
     * @param dto 任务
     * @return 影响行数
     */
    Integer update(CcbBillPushTaskDto dto);

    /**
     * 根据ID查询
     *
     * @param id 主键
     * @return 任务
     */
    CcbBillPushTaskDto findById(Long id);

    /**
     * 分页查询
     *
     * @param param 条件与分页入参
     * @return 结果列表
     */
    List<CcbBillPushTaskDto> selectPage(CcbBillPushTaskPageParam param);

    /**
     * 分页计数
     *
     * @param param 条件与分页入参
     * @return 记录数
     */
    Integer selectCount(CcbBillPushTaskPageParam param);
}
