package cn.com.duiba.quanyi.center.api.remoteservice.mall.credits;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.mall.credits.TrusteeshipCreditRecordDto;
import cn.com.duiba.quanyi.center.api.param.mall.credits.BatchImportCreditsParam;

/**
 * 托管积分记录表
 * @author kjj mybatis generator 
 * @date 2025-04-29
 */
@AdvancedFeignClient
public interface RemoteTrusteeshipCreditRecordService {

    /**
     * 查询导入积分记录
     * @param batchImportCreditsParam
     * @return
     */
    List<TrusteeshipCreditRecordDto> selectByImportCustomerInfo(BatchImportCreditsParam batchImportCreditsParam);

    /**
     * 批量导入积分
     * @param batchImportCreditsParam
     * @return
     */
    BaseResultDto<Boolean> batchImportCredits(BatchImportCreditsParam batchImportCreditsParam);

    /**
     * 查询即将过期积分
     * @param accountId 账户id
     * @return
     */
    Long selectCloseExpireCredits(Long accountId);

    /**
     * 根据thirdOnlyId集合、companyId和bizNo集合查询
     * @param thirdOnlyIds 三方唯一标识集合
     * @param companyId 公司id
     * @param bizNos 业务编码集合
     * @return 托管积分记录DTO列表
     */
    List<TrusteeshipCreditRecordDto> selectByThirdOnlyIdsAndBizNos(List<String> thirdOnlyIds, Long companyId, List<String> bizNos);

}