package cn.com.duiba.quanyi.center.api.remoteservice.mall.version;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.version.MallVersionExtDto;

/**
 * 商城版本ext
 * @author kjj mybatis generator 
 * @date 2024-06-11
 */
@AdvancedFeignClient
public interface RemoteMallVersionExtService {

    /**
     * 根据商城版本查询
     * @param mallVersion 商城版本
     * @return 商城版本ext
     */
    List<MallVersionExtDto> selectByVersion(Long mallVersion, Integer bizType);

    /**
     * 根据配置值和业务类型查询
     * @param confValue 配置值
     * @param bizType 业务类型
     * @return 商城版本ext列表
     */
    List<MallVersionExtDto> selectByConfValueAndBizType(String confValue, Integer bizType);
}