/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.log.operate;

import cn.com.duiba.quanyi.center.api.utils.QuanYiStringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

public class LogAopUtil {
    private static final Logger log = LoggerFactory.getLogger(LogAopUtil.class);

    private LogAopUtil() {
    }

    public static String getPath(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        return LogAopUtil.clearRequestUri(request.getRequestURI());
    }

    public static String clearRequestUri(String requestUri) {
        if (StringUtils.isBlank((CharSequence)requestUri)) {
            return requestUri;
        }
        return StringUtils.replace((String)requestUri, (String)"//", (String)"/");
    }

    public static String getRequestBody(ProceedingJoinPoint joinPoint, int maxLength, int valueMaxLength) {
        JSONObject paramObj = LogAopUtil.getFieldsName(joinPoint, valueMaxLength);
        return QuanYiStringUtils.subStringIfAbsent(paramObj.toJSONString(), maxLength);
    }

    public static Method getMethod(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        return signature.getMethod();
    }

    public static JSONObject getFieldsName(ProceedingJoinPoint joinPoint, int valueMaxLength) {
        Object[] args = joinPoint.getArgs();
        DefaultParameterNameDiscoverer pnd = new DefaultParameterNameDiscoverer();
        Method method = LogAopUtil.getMethod(joinPoint);
        String[] parameterNames = pnd.getParameterNames(method);
        JSONObject paramObj = new JSONObject();
        if (parameterNames == null || parameterNames.length < 1) {
            return paramObj;
        }
        for (int i = 0; i < Objects.requireNonNull(parameterNames).length; ++i) {
            Object ob = args[i];
            if (ob instanceof HttpServletRequest || ob instanceof HttpServletResponse || ob instanceof BindingResult || ob instanceof MultipartFile) continue;
            paramObj.put(parameterNames[i], (Object)LogAopUtil.toJsonStringAndSubIfAbsent(ob, valueMaxLength));
        }
        return paramObj;
    }

    public static String getResponseBody(Object obj, int maxLength, int valueMaxLength) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return LogAopUtil.toJsonStringAndSubIfAbsent(obj, maxLength);
        }
        try {
            Object jsonObj = JSON.toJSON((Object)obj);
            if (jsonObj instanceof JSONObject) {
                return LogAopUtil.subValueIfAbsent((JSONObject)jsonObj, maxLength, valueMaxLength);
            }
            return LogAopUtil.toJsonStringAndSubIfAbsent(obj, maxLength);
        }
        catch (Exception e) {
            log.info("access log aop warn obj={}", obj, (Object)e);
            return LogAopUtil.toJsonStringAndSubIfAbsent(obj, maxLength);
        }
    }

    private static String subValueIfAbsent(JSONObject jsonObj, int maxLength, int valueMaxLength) {
        jsonObj.replaceAll((k, v) -> LogAopUtil.toJsonStringAndSubIfAbsent(v, valueMaxLength));
        return LogAopUtil.toJsonStringAndSubIfAbsent(jsonObj, maxLength);
    }

    private static String toJsonStringAndSubIfAbsent(Object obj, int maxLength) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return QuanYiStringUtils.subStringAndAddLog((String)obj, maxLength);
        }
        try {
            return QuanYiStringUtils.subStringAndAddLog(JSON.toJSONString((Object)obj), maxLength);
        }
        catch (Exception e) {
            log.info("access log aop warn obj={}", obj, (Object)e);
            return QuanYiStringUtils.subStringAndAddLog(obj.toString(), maxLength);
        }
    }
}

