/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SpuTypeEnum {
    OBJECT(1, "\u5b9e\u7269"),
    WX_COUPON(2, "\u5fae\u4fe1\u7acb\u51cf\u91d1"),
    ALIPAY_COUPON(3, "\u652f\u4ed8\u5b9d\u7acb\u51cf\u91d1"),
    I_QI_YI_ZC(4, "\u7231\u5947\u827a\u76f4\u5145"),
    ALIPAY_COUNT_COINS(5, "\u652f\u4ed8\u5b9d\u6570\u5e01\u7ea2\u5305"),
    CCB_COUNT_COINS(6, "\u5efa\u884c\u6570\u5e01\u7ea2\u5305");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, SpuTypeEnum> ENUM_MAP;

    public static SpuTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private SpuTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(SpuTypeEnum.values()).collect(Collectors.toMap(SpuTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

