package cn.com.duiba.quanyi.goods.service.api.enums.order.supplier;


import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 供应商订单表的 orderStatus 字段枚举
 *
 * @author guoyanfei
 * @date 2023/2/21
 */
@Getter
@AllArgsConstructor
public enum SupplierOrderStatusEnum {

    CREATED(0, "创建"),
    IN_PROCESS(1, "处理中"),
    SUCCEED(2, "成功"),
    FAILED(3, "失败, 无法自动重试成功"),
    EXCEPTION(4, "异常"),
    FAIL_CAN_RETRY(5, "失败, 自动重试可能会成功"),
    VERIFICATION(11, "已核销"),
    ;

    private final Integer code;

    private final String desc;

    private static final Map<Integer, SupplierOrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SupplierOrderStatusEnum::getCode, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param code 枚举值
     * @return 枚举
     */
    public static SupplierOrderStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
