package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.jd.JdECardZcOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.jd.JdZcSmsReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.jd.JdECardZcOrderResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.jd.JdZcSmsCodeResult;

/**
 * RemoteOrderProcessorJdECardService
 *
 * @author fumingkun
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorJdECardService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<JdECardZcOrderCreateReq> dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    JdECardZcOrderResult findOrderResult(String customerOrderNo);

    /**
     * 京东发送验证码
     * @param req 请求参数 
     * @return 发送结果
     */
    JdZcSmsCodeResult jdSmsSend(JdZcSmsReq req);
}
