package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 商品类型
 *
 * @author lizhi
 * @date 2023/11/20 11:46
 */
@Getter
@AllArgsConstructor
public enum SpuTypeEnum {

    OBJECT(1, "实物", PurchaseSpuTypeEnum.OBJECT),
    WX_COUPON(2, "微信立减金", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    ALIPAY_COUPON(3, "支付宝立减金", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    I_QI_YI_ZC(4, "爱奇艺直充", PurchaseSpuTypeEnum.ZC),
    ALIPAY_COUNT_COINS(5, "支付宝数币红包", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    CCB_COUNT_COINS(6, "建行数币红包", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    KA_MI(7, "卡密", PurchaseSpuTypeEnum.KA_MI),
    MEI_TUAN_STORE(8, "美团到店", PurchaseSpuTypeEnum.ZC),
    YOU_KU(9, "优酷", PurchaseSpuTypeEnum.ZC),
    TE_LAI_DIAN_COUPON(10, "特来电卡劵直充", PurchaseSpuTypeEnum.ZC),
    TUAN_YOU(11, "团油", PurchaseSpuTypeEnum.ZC),
    WX_TRANSFER(12, "微信到零钱", PurchaseSpuTypeEnum.ZC),
    BA_WANG_CHA_JI(16, "霸王茶姬", PurchaseSpuTypeEnum.ZC),
    CLOUD_360_VIP(13, "360安全云盘会员", PurchaseSpuTypeEnum.ZC),
    HUA_FEI(14, "话费", PurchaseSpuTypeEnum.ZC),
    MI_GU_VIDEO_VIP(17, "咪咕视频会员", PurchaseSpuTypeEnum.ZC),
    QQ_VIP(18, "QQ会员", PurchaseSpuTypeEnum.ZC),
    TEN_XUN_QQ_MUSIC_VIP(19, "腾讯QQ音乐会员", PurchaseSpuTypeEnum.ZC),
    DIDI_CAR_COUPON(20, "滴滴快车代金券", PurchaseSpuTypeEnum.ZC),
    RUI_XING_COFFE_ZC(21, "瑞幸咖啡直充", PurchaseSpuTypeEnum.ZC),
    QB(22, "Q币", PurchaseSpuTypeEnum.ZC),
    CLOUD_BAI_DU_VIP(24, "百度云盘会员", PurchaseSpuTypeEnum.ZC),
    WANG_YI_YUN_VIP(25, "网易云会员", PurchaseSpuTypeEnum.ZC),
    TEN_XUN_VIDEO_VIP(26, "腾讯视频会员", PurchaseSpuTypeEnum.ZC),
    NAI_XUE_ZC(23, "奈雪直充", PurchaseSpuTypeEnum.ZC),
    BI_LI_BI_LI_VIP(27, "哔哩哔哩会员", PurchaseSpuTypeEnum.ZC),
    MANG_GUO_TV_VIP(28, "芒果移动影视会员", PurchaseSpuTypeEnum.ZC),
    XI_MA_LA_YA_VIP(29, "喜马拉雅会员", PurchaseSpuTypeEnum.ZC),
    WX_RED_PACKET(30, "微信红包", PurchaseSpuTypeEnum.ZC),
    J_D_E_CARD(31, "京东E卡", PurchaseSpuTypeEnum.ZC),
    HANG_LV_ZONG_HENG(32, "航旅纵横直充", PurchaseSpuTypeEnum.ZC),
    CNPC(33, "中石油", PurchaseSpuTypeEnum.ZC),
    SINOPEC(34, "中石化", PurchaseSpuTypeEnum.ZC),
    HONG_EN_ZC(35, "洪恩直充", PurchaseSpuTypeEnum.ZC),
    WX_MORE_TRANSFER(36, "微信大额转账", PurchaseSpuTypeEnum.ZC),
    BANK_MORE_TRANSFER(37, "银行卡大额转账", PurchaseSpuTypeEnum.ZC),
    MEI_TUAN_COUPON(38, "美团外卖代金券", PurchaseSpuTypeEnum.ZC),
    MI_XUE_BING_CHENG(39, "蜜雪冰城", PurchaseSpuTypeEnum.ZC),
    TU_HU_COUPON(40, "途虎洗车券", PurchaseSpuTypeEnum.ZC),
    GAO_DE_COUPON(41, "高德打车券", PurchaseSpuTypeEnum.ZC),
    WPS_VIP(42, "wps会员", PurchaseSpuTypeEnum.ZC),
    MANG_GUO_QUAN_PING_VIP(43, "芒果全屏影视会员", PurchaseSpuTypeEnum.ZC),
    DOU_YIN_COUPON(44, "抖音团购券", PurchaseSpuTypeEnum.ZC),
    GU_MING_COUPON(45, "古茗代金券", PurchaseSpuTypeEnum.ZC),
    QQ_READ_VIP(46, "腾讯QQ阅读会员", PurchaseSpuTypeEnum.ZC),
    DIDI_QJ_RIDING(47, "滴滴青桔骑行卡", PurchaseSpuTypeEnum.ZC),
    CAR_SER(48, "汽车服务", PurchaseSpuTypeEnum.CAR_SER),
    E_LE_ME_VIP(49, "饿了么超级会员", PurchaseSpuTypeEnum.ZC),
    DOU_YIN_PAY_COUPON(50, "抖音支付券", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    MEI_TUAN_PAY_COUPON(51, "美团支付券", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    ADVANCE_PAYMENT(52,"垫资", PurchaseSpuTypeEnum.ADVANCE_PAYMENT),
    WX_COUPON_THIRD(53, "微信立减金-三方", PurchaseSpuTypeEnum.ZC),
    XIAO_JU_ZC(54,"小桔直充", PurchaseSpuTypeEnum.ZC),
    XING_XING_ZC(55,"星星直充", PurchaseSpuTypeEnum.ZC),
    ALIPAY_COUPON_THIRD(56,"支付宝立减金-三方", PurchaseSpuTypeEnum.ZC),
    SHUN_YI_CHONG_ZC(57, "顺易充直充", PurchaseSpuTypeEnum.ZC),
    CHE_DIAN_DIAN_ZC(58, "车点点直充", PurchaseSpuTypeEnum.ZC),
    XUN_LEI_VIP(59, "迅雷会员", PurchaseSpuTypeEnum.ZC),
    ZHI_HU_VIP(60, "知乎盐选会员", PurchaseSpuTypeEnum.ZC),
    KEEP_VIP(61, "KEEP会员", PurchaseSpuTypeEnum.ZC),
    LAN_REN_VIP(62, "懒人畅听会员", PurchaseSpuTypeEnum.ZC),
    KU_GOU_VIP(63, "酷狗音乐会员", PurchaseSpuTypeEnum.ZC),
    ;

    private final Integer type;

    private final String desc;
    
    private final PurchaseSpuTypeEnum purchaseSpuType;

    public PurchaseSpuTypeEnum getPurchaseSpuType() {
        return purchaseSpuType;
    }

    private static final Map<Integer, SpuTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SpuTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    private static final Map<Integer, List<SpuTypeEnum>> PURCHASE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.groupingBy(s -> s.getPurchaseSpuType().getType())));
    private static final Map<Integer, Set<Integer>> PURCHASE_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.groupingBy(s -> s.getPurchaseSpuType().getType(), Collectors.mapping(SpuTypeEnum::getType, Collectors.toSet()))));

    /**
     * 根据枚举值获取枚举
     *
     * @param type 枚举值
     * @return 枚举
     */
    public static SpuTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据采购商品类型，获取对应的spuType枚举集合
     * 
     * @param purchaseSpuType 采购商品类型
     * @return spuType枚举集合
     */
    public static List<SpuTypeEnum> getEnumByPurchaseSpuType(Integer purchaseSpuType) {
        List<SpuTypeEnum> spuTypeEnums = PURCHASE_ENUM_MAP.get(purchaseSpuType);
        if (spuTypeEnums == null) {
            return Collections.emptyList();
        }
        return spuTypeEnums;
    }

    /**
     * 根据采购商品类型，获取对应的spuType集合
     * 
     * @param purchaseSpuType 采购商品类型
     * @return spuType集合
     */
    public static Set<Integer> getByPurchaseSpuType(Integer purchaseSpuType) {
        Set<Integer> types = PURCHASE_TYPE_MAP.get(purchaseSpuType);
        if (types == null) {
            return Collections.emptySet();
        }
        return types;
    }
}
