package cn.com.duiba.quanyi.goods.service.api.enums.supplier;

import cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 虚拟商品供应商code枚举
 * 2023/2/9 .
 *
 * @author guoyanfei
 */
@Getter
@AllArgsConstructor
public enum SupplierApiCodeEnum {
    WX_FAVOR_ZY("wx_favor_zy", "微信立减金", SpuTypeEnum.WX_COUPON, true),
    ALIPAY_COUPON_CARD("alipay_coupon_card", "支付宝立减金", SpuTypeEnum.ALIPAY_COUPON, true),
    I_QI_YI_ZC("i_qi_yi_zc", "爱奇艺直充", SpuTypeEnum.I_QI_YI_ZC, true),
    ALIPAY_COUNT_COINS("alipay_count_coins", "支付宝数币红包", SpuTypeEnum.ALIPAY_COUNT_COINS, true),
    CCB_PAY_COUNT_COINS("ccb_count_coins", "建行数币红包", SpuTypeEnum.CCB_COUNT_COINS, true),
    CARD_SECRET("card_secret", "卡密", SpuTypeEnum.KA_MI, true),
    MEI_TUAN_STORE_Y_S_S_H_ZC("y_s_s_h_mei_tuan_store", "美团到店-银盛数惠-直冲", SpuTypeEnum.MEI_TUAN_STORE, true),
    YOU_KU_YI_AN("youku_yian", "易安优酷", SpuTypeEnum.YOU_KU, true),
    YOUKU_YIPAI("youku_yipai", "优酷-易派", SpuTypeEnum.YOU_KU, true),
    YOUKU_VIP_ZC("youku_vip_zc", "优酷会员直充", SpuTypeEnum.YOU_KU, true),
    TE_LAI_DIAN_COUPON_ZC("te_lai_dian_coupon", "特来电卡券直充", SpuTypeEnum.TE_LAI_DIAN_COUPON, true),
    TUAN_YOU_YI_AN("tuan_you_yi_an", "团油易安", SpuTypeEnum.TUAN_YOU, true),
    WX_TRANSFER_JI_GAO("wx_transfer_ji_gao", "微信到零钱-继皋", SpuTypeEnum.WX_TRANSFER, true),
    BA_WANG_CHA_JI_QI_MAI("ba_wang_cha_ji_qi_mai", "霸王茶姬-企迈", SpuTypeEnum.BA_WANG_CHA_JI, true),
    MI_GU_VIDEO_VIP_TE_ZHEN("mi_gu_video_vip_te_zhen", "咪咕视频会员-特祯", SpuTypeEnum.MI_GU_VIDEO_VIP, true),
    QQ_VIP_TE_ZHEN("qq_vip_te_zhen", "QQ会员-特祯", SpuTypeEnum.QQ_VIP, true),
    TEN_XUN_QQ_MUSIC_VIP_TE_ZHEN("ten_xun_qq_music_vip_te_zhen", "腾讯QQ音乐会员-特祯", SpuTypeEnum.TEN_XUN_QQ_MUSIC_VIP, true),
    DIDI_CAR_COUPON_TE_ZHEN("di_di_car_coupon_te_zhen", "滴滴快车代金劵-特祯", SpuTypeEnum.DIDI_CAR_COUPON, true),
    RUI_XING_COFFEE_ZC_TE_ZHEN("rui_xing_coffee_zc_te_zhen", "瑞希咖啡直充-特祯", SpuTypeEnum.RUI_XING_COFFE_ZC, true),
    CLOUD_360_VIP("cloud_360_vip", "360安全云盘会员", SpuTypeEnum.CLOUD_360_VIP, true),
    CHONG_DA_HUA_FEI("chong_da_hua_fei", "充达无票话费", SpuTypeEnum.HUA_FEI, true),
    WX_TRANSFER_KA_CHI("wx_transfer_ka_chi", "微信到零钱-卡池", SpuTypeEnum.WX_TRANSFER, true),
    QB_DIAN_DIAN("qb_dian_dian", "Q币-点点", SpuTypeEnum.QB, true),
    I_QI_YI_DIAN_DIAN("i_qi_yi_dian_dian", "爱奇艺-点点", SpuTypeEnum.I_QI_YI_ZC, true),
    NAI_XUE_ZC("nai_xue_zc", "奈雪直充", SpuTypeEnum.NAI_XUE_ZC, true),
    FEI_HAN_BI_LI_BI_LI_VIP("fei_han_bi_li_bi_li_vip", "哔哩哔哩会员-飞翰", SpuTypeEnum.BI_LI_BI_LI_VIP, true),
    CLOUD_BAI_DU_VIP_DING_XIN("cloud_bai_du_vip_ding_xin", "百度网盘会员-鼎盛", SpuTypeEnum.CLOUD_BAI_DU_VIP, true),
    WANG_YI_YUN_VIP_DING_XIN("wang_yi_yun_vip_ding_xin", "网易云会员-鼎盛", SpuTypeEnum.WANG_YI_YUN_VIP, true),
    TEN_XUN_VIDEO_VIP_DING_XIN("ten_xun_video_vip_ding_xin", "腾讯视频会员-鼎盛", SpuTypeEnum.TEN_XUN_VIDEO_VIP, true),
    WX_RED_PACKET_JI_GAO("wx_red_packet_ji_gao", "微信红包-继皋", SpuTypeEnum.WX_RED_PACKET, true),
    MANG_GUO_T_V_VIP_FU_LU("mang_guo_tv_vip_fu_lu", "芒果TV会员-福禄", SpuTypeEnum.MANG_GUO_TV_VIP , true),
    XI_MA_LA_YA_VIP_YI_PAI("xi_ma_la_ya_vip_yi_pai", "喜马拉雅会员-易派", SpuTypeEnum.XI_MA_LA_YA_VIP , true),
    TENCENT_VIDEO_VIP_DIAN_DIAN("tencent_video_vip_dian_dian", "腾讯视频会员-点点", SpuTypeEnum.TEN_XUN_VIDEO_VIP, true),
    J_D_E_CARD("j_d_e_card", "京东E卡", SpuTypeEnum.J_D_E_CARD , true),
    HUA_FEI_KA_CHI("hua_fei_ka_chi", "话费-卡池", SpuTypeEnum.HUA_FEI, true),
    WX_TRANSFER_SHEN_BIAN_YUN("wx_transfer_shen_bian_yun", "微信到零钱-身边云", SpuTypeEnum.WX_TRANSFER, true),
    HANG_LV_ZONG_HENG_ZC("hang_lv_zong_heng_zc", "航旅纵横直充", SpuTypeEnum.HANG_LV_ZONG_HENG, true),
    CNPC_ANYI("cnpc_anyi", "中石油-安怡", SpuTypeEnum.CNPC, true),
    SINOPEC_ANYI("sinopec_anyi", "中石化-安怡", SpuTypeEnum.SINOPEC, true),
    CNPC_SHENGMA("cnpc_shengma", "中石油-盛马", SpuTypeEnum.CNPC, true),
    SINOPEC_SHENGMA("sinopec_shengma", "中石化-盛马", SpuTypeEnum.SINOPEC, true),
    HONG_EN_COUPON_ZC("hong_en_zc", "洪恩直充", SpuTypeEnum.HONG_EN_ZC, true),
    TUAN_YOU("tuan_you", "团油", SpuTypeEnum.TUAN_YOU, true),
    MEI_TUAN_COUPON_YI_PAI("mei_tuan_coupon_yi_pai", "美团外卖代金券-易派", SpuTypeEnum.MEI_TUAN_COUPON, true),
    TEN_XUN_QQ_MUSIC_VIP_FU_LU("ten_xun_qq_music_vip_fu_lu", "腾讯QQ音乐会员-福禄", SpuTypeEnum.TEN_XUN_QQ_MUSIC_VIP, true),
    TEN_XUN_VIDEO_VIP_FU_LU("ten_xun_qq_video_vip_fu_lu", "腾讯视频会员-福禄", SpuTypeEnum.TEN_XUN_VIDEO_VIP, true),
    WX_MORE_TRANSFER_SHEN_BIAN_YUN("wx_more_transfer_shen_bian_yun", "微信大额转账-身边云", SpuTypeEnum.WX_MORE_TRANSFER, true),
    BANK_MORE_TRANSFER_SHEN_BIAN_YUN("bank_more_transfer_shen_bian_yun", "银行卡大额转账-身边云", SpuTypeEnum.BANK_MORE_TRANSFER, true),
    RUI_XIN_COFFEE_DING_XING("rui_xin_coffee_ding_xin", "瑞辛咖啡代金券-鼎信", SpuTypeEnum.RUI_XING_COFFE_ZC, true),
    BI_LI_BI_LI_VIP_TE_ZHEN("bi_li_bi_li_vip_te_zhen", "哔哩哔哩会员-特祯", SpuTypeEnum.BI_LI_BI_LI_VIP, true),
    MI_XUE_BING_CHENG_TE_ZHEN("mi_xue_bing_cheng_te_zhen", "蜜雪冰城-特祯", SpuTypeEnum.MI_XUE_BING_CHENG, true),
    TU_HU_COUPON_PU_MAI("tu_hu_coupon_pu_mai", "途虎洗车券-普麦", SpuTypeEnum.TU_HU_COUPON, true),
    GAO_DE_COUPON_PU_MAI("gao_de_coupon_pu_mai", "高德打车券-普麦", SpuTypeEnum.GAO_DE_COUPON, true),
    WPS_VIP_PU_MAI("wps_vip_pu_mai", "wps会员-普麦", SpuTypeEnum.WPS_VIP, true),
    MANG_GUO_TV_QUAN_PING_VIP_PU_MAI("mang_guo_tv_quan_ping_vip_pu_mai", "芒果全屏影视会员-普麦", SpuTypeEnum.MANG_GUO_QUAN_PING_VIP, true),
    MANG_GUO_TV_YI_DONG_VIP_PU_MAI("mang_guo_tv_yi_dong_vip_pu_mai", "芒果移动影视会员-普麦", SpuTypeEnum.MANG_GUO_TV_VIP, true),
    I_QI_YI_VIP_PU_MAI("i_qi_yi_vip_pu_mai", "爱奇艺会员-普麦", SpuTypeEnum.I_QI_YI_ZC, true),
    TEN_XUN_QQ_MUSIC_VIP_DING_XIN("ten_xun_qq_music_vip_ding_xin", "腾讯QQ音乐会员-鼎信", SpuTypeEnum.TEN_XUN_QQ_MUSIC_VIP, true),
    CHENG_YI_DOU_YIN_COUPON("cheng_yi_dou_yin_coupon", "抖音团购券-骋翼", SpuTypeEnum.DOU_YIN_COUPON, true),
    SU_XI_HUA_FEI("su_xi_hua_fei", "苏西话费", SpuTypeEnum.HUA_FEI, true),
    GU_MING_COUPON("gu_ming_coupon", "古茗代金券", SpuTypeEnum.GU_MING_COUPON, true),
    RUI_XING_COFFE_ZC_QING_TIAN("rui_xing_coffee_qing_tian", "瑞幸咖啡直充-晴天", SpuTypeEnum.RUI_XING_COFFE_ZC, true),
    QQ_READ_VIP_QING_TIAN("qq_read_vip_qing_tian", "QQ阅读会员-晴天", SpuTypeEnum.QQ_READ_VIP, true),
    WANG_YI_YUN_VIP_QING_TIAN("wang_yi_yun_vip_qing_tian", "网易云黑胶会员-晴天", SpuTypeEnum.WANG_YI_YUN_VIP, true),
    WANG_YI_YUN_VIP_YI_LI("wang_yi_yun_vip_yi_li", "网易云音乐月卡-翌理", SpuTypeEnum.WANG_YI_YUN_VIP, true),
    WANG_YI_YUN_VIP_FENG_ZHU_SHOU("wang_yi_yun_vip_feng_zhu_shou", "网易云音乐月卡-蜂助手", SpuTypeEnum.WANG_YI_YUN_VIP, true),
    QQ_VIP_QING_TIAN("qq_vip_qing_tian", "QQ会员-晴天", SpuTypeEnum.QQ_VIP, true),
    DIDI_QJ_RIDING_QING_TIAN("didi_qj_riding_qing_tian", "滴滴青桔骑行卡-晴天", SpuTypeEnum.DIDI_QJ_RIDING, true),
    MEI_TUAN_COUPON_PU_MAI("mei_tuan_coupon_pu_mai", "美团外卖代金券-普麦", SpuTypeEnum.MEI_TUAN_COUPON, true),
    MEI_TUAN_COUPON_QING_TIAN("mei_tuan_coupon_qing_tian", "美团外卖代金券-晴天", SpuTypeEnum.MEI_TUAN_COUPON, true),
    CAR_SER_DB("car_ser_db", "汽车服务-兑吧", SpuTypeEnum.CAR_SER, true),
    CAR_SER_AFTER("car_ser_after", "汽车服务-车后", SpuTypeEnum.CAR_SER, true),
    CAR_SER_MOM("car_ser_mom", "汽车服务-车妈妈", SpuTypeEnum.CAR_SER, true),
    CAR_SER_EASY("car_ser_easy", "汽车服务-车行易", SpuTypeEnum.CAR_SER, true),
    I_QI_YI_VIP_FENG_ZHU_SHOU("i_qi_yi_vip_feng_zhu_shou", "爱奇艺会员-蜂助手", SpuTypeEnum.I_QI_YI_ZC, true),
    E_LE_ME_VIP_DING_XIN("e_le_me_vip_ding_xin", "饿了么会员-鼎信", SpuTypeEnum.E_LE_ME_VIP, true),
    E_LE_ME_VIP_FU_LU("e_le_me_vip_fu_lu", "饿了么会员-福禄", SpuTypeEnum.E_LE_ME_VIP, true),
    YOU_KU_QING_TIAN("you_ku_qing_tian", "优酷-晴天", SpuTypeEnum.YOU_KU, true),
    WX_TRANSFER_HAN_GONG_YUN("wx_transfer_han_gong_yun", "微信到零钱-汉工云", SpuTypeEnum.WX_TRANSFER, true),
    DOU_YIN_PAY_COUPON("douyin_pay_coupon", "抖音支付券", SpuTypeEnum.DOU_YIN_PAY_COUPON, true),

    KACHI_ALIPAY_COUPON_CARD("kachi_alipay_coupon_card", "支付宝立减金-卡池", SpuTypeEnum.ALIPAY_COUPON, true),
    MEI_TUAN_PAY_COUPON("mei_tuan_pay_coupon", "美团支付劵", SpuTypeEnum.MEI_TUAN_PAY_COUPON, true),
    ZHONG_HENG_HUA_FEI("zhong_heng_hua_fei", "话费-中恒", SpuTypeEnum.HUA_FEI, true),
    WX_TRANSFER_KUAI_KUAI_SHOU("wx_transfer_kuai_kuai_shou", "微信零钱-快快收", SpuTypeEnum.WX_TRANSFER, true),
    I_QI_YI_DING_XIN("i_qi_yi_ding_xin", "爱奇艺-鼎信", SpuTypeEnum.I_QI_YI_ZC, true),
    BA_WANG_CHA_JI_JI_GAO("ba_wang_cha_ji_ji_gao", "霸王茶姬-继皋", SpuTypeEnum.BA_WANG_CHA_JI, true),
    ALIPAY_COUPON_THIRD_WAN_HENG("alipay_coupon_third_wan_heng", "支付宝立减金三方-万恒", SpuTypeEnum.ALIPAY_COUPON_THIRD, true),
    MEI_TUAN_COUPON_DING_XIN("mei_tuan_coupon_ding_xin", "美团外卖代金券-鼎信", SpuTypeEnum.MEI_TUAN_COUPON, true),
    XING_XING_COUPON_ZC("xing_xing_coupon_zc", "星星优惠券直充", SpuTypeEnum.XING_XING_ZC, true),
    XIAO_JU_COUPON_ZC("xiao_ju_coupon_zc", "小桔直充", SpuTypeEnum.XIAO_JU_ZC, true),
    WX_COUPON_ZHONGLIAN("wx_coupon_zhonglian", "微信立减金-众联", SpuTypeEnum.WX_COUPON_THIRD, true),
    SHUN_YI_CHONG_ZC("shun_yi_chong_zc", "顺易充直充", SpuTypeEnum.SHUN_YI_CHONG_ZC, true),
    CHE_DIAN_DIAN_ZC("che_dian_dian_zc", "车点点直充", SpuTypeEnum.CHE_DIAN_DIAN_ZC, true),
    WX_TRANSFER_FU_AO("wx_transfer_fu_ao", "微信到零钱-富奥", SpuTypeEnum.WX_TRANSFER, true),
    XING_XING_ZC_XIAO_JIAN("xing_xing_zc_xiao_jian", "星星直充-晓见", SpuTypeEnum.XING_XING_ZC, true),
    TENCENT_VIDEO_VIP_TE_ZHEN("tencent_video_vip_te_zhen", "腾讯视频会员-特祯", SpuTypeEnum.TEN_XUN_VIDEO_VIP, true),
    TENCENT_VIDEO_VIP_PU_MAI("tencent_video_vip_pu_mai", "腾讯视频会员-普麦", SpuTypeEnum.TEN_XUN_VIDEO_VIP, true),
    XUN_LEI_VIP_TE_ZHEN("xun_lei_vip_te_zhen", "迅雷会员-特祯", SpuTypeEnum.XUN_LEI_VIP, true),
    YOU_KU_TE_ZHEN("you_ku_te_zhen", "优酷会员-特祯", SpuTypeEnum.YOU_KU, true),
    BI_LI_BI_LI_VIP_DING_XIN("bi_li_bi_li_vip_ding_xin", "哔哩哔哩会员-鼎信", SpuTypeEnum.BI_LI_BI_LI_VIP, true),
    ZHI_HU_VIP_YI_PAI("zhi_hu_vip_yi_pai", "知乎会员-易派", SpuTypeEnum.ZHI_HU_VIP, true),
    KEEP_VIP_PU_MAI("keep_vip_pu_mai", "Keep会员-普麦", SpuTypeEnum.KEEP_VIP, true),
    LAN_REN_VIP_FU_LU("lan_ren_vip_fu_lu", "懒人畅听会员-福禄", SpuTypeEnum.LAN_REN_VIP, true),
    KU_GOU_VIP_DING_XIN("ku_gou_vip_ding_xin", "酷狗会员-鼎信", SpuTypeEnum.KU_GOU_VIP, true)
    ;

    private final String code;
    private final String desc;
    private final SpuTypeEnum spuType;
    private final boolean canSelect;

    private static final Map<String, SupplierApiCodeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SupplierApiCodeEnum::getCode, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param code 枚举值
     * @return 枚举
     */
    public static SupplierApiCodeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
