package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.alipay;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 支付宝立减金发放
 *
 * @author lizhi
 * @date 2023/4/17 1:36 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AlipayCouponOrderCreateReq extends BaseOrderCreateExtReq {

    private static final long serialVersionUID = -4429821352256408204L;

    /**
     * 支付宝用户ID
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：UID为用户唯一标识，可通过授权方式获取，具体见产品文档。
     * 特殊可选，最大长度16
     */
    private String userId;

    /**
     * 映射user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    private String openId;

    /**
     * 支付宝用户ID
     * user_id，logon_id，phone_id不能同时为空，优先级依次降低。
     * 注：若手机号为非用户注册支付宝账号，则会发放失败。
     * 特殊可选，最大长度128
     */
    private String loginId;

    /**
     * 该参数将先匹配用户手机号对应支付宝账号，若存在且完成实名认证则以此支付宝账号发放，若该支付宝账号未完成实名认证则发放失败；若用户手机号对应支付宝账号不存在，则再匹配用户手机号绑定支付宝账号。
     * 若用户手机号绑定多个支付宝账号，则以系统判定的常用支付宝账号为准。请优先使用user_id和logon_id。
     * 特殊可选，最大长度11
     */
    private String phoneId;

    /**
     * 数字分行活动id
     * 必选，最大长度32
     */
    private String actId;

    /**
     * 支付宝分配给开发者的应用ID
     * 必选，最大长度32
     */
    private String appId;

    /**
     * 是否需要退回状态
     */
    private boolean needRefundStatus;

    /**
     * 是否需要过期状态
     */
    private boolean needExpiredStatus;

    /**
     * 时间周期类型 ABSOLUTELY:绝对时间RELATIVE:相对时间
     */
    private String couponAvailablePeriodType;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为ABSOLUTELY时，此处会有值 绝对时间情况下，红包发放开始时间
     */
    private Date couponAbsolutelyBeginTime;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为ABSOLUTELY时，此处会有值 绝对时间下红包发放结束时间
     */
    private Date couponAbsolutelyEndTime;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包发放开始时间周期类型 IMMEDIATELY: 立即生效 NEXT_DAY: 次日零点
     */
    private String couponRelativeBeginRoundingType;

    /**
     * 目前只有天
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包开始时间相对值，比如:coupon_relative_end_rounding_type=MINUTES coupon_relative_end_value=100 代表从生效时间开始，有效期持续为100分钟
     */
    private Long couponRelativeEndValue;
}
