/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import cn.com.duiba.quanyi.goods.service.api.enums.goods.PurchaseSpuTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SpuTypeEnum {
    OBJECT(1, "\u5b9e\u7269", PurchaseSpuTypeEnum.OBJECT),
    WX_COUPON(2, "\u5fae\u4fe1\u7acb\u51cf\u91d1", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    ALIPAY_COUPON(3, "\u652f\u4ed8\u5b9d\u7acb\u51cf\u91d1", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    I_QI_YI_ZC(4, "\u7231\u5947\u827a\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    ALIPAY_COUNT_COINS(5, "\u652f\u4ed8\u5b9d\u6570\u5e01\u7ea2\u5305", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    CCB_COUNT_COINS(6, "\u5efa\u884c\u6570\u5e01\u7ea2\u5305", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    KA_MI(7, "\u5361\u5bc6", PurchaseSpuTypeEnum.KA_MI),
    MEI_TUAN_STORE(8, "\u7f8e\u56e2\u5230\u5e97", PurchaseSpuTypeEnum.ZC),
    YOU_KU(9, "\u4f18\u9177", PurchaseSpuTypeEnum.ZC),
    TE_LAI_DIAN_COUPON(10, "\u7279\u6765\u7535\u5361\u52b5\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    TUAN_YOU(11, "\u56e2\u6cb9", PurchaseSpuTypeEnum.ZC),
    WX_TRANSFER(12, "\u5fae\u4fe1\u5230\u96f6\u94b1", PurchaseSpuTypeEnum.ZC),
    BA_WANG_CHA_JI(16, "\u9738\u738b\u8336\u59ec", PurchaseSpuTypeEnum.ZC),
    CLOUD_360_VIP(13, "360\u5b89\u5168\u4e91\u76d8\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    HUA_FEI(14, "\u8bdd\u8d39", PurchaseSpuTypeEnum.ZC),
    MI_GU_VIDEO_VIP(17, "\u54aa\u5495\u89c6\u9891\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    QQ_VIP(18, "QQ\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    TEN_XUN_QQ_MUSIC_VIP(19, "\u817e\u8bafQQ\u97f3\u4e50\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    DIDI_CAR_COUPON(20, "\u6ef4\u6ef4\u5feb\u8f66\u4ee3\u91d1\u5238", PurchaseSpuTypeEnum.ZC),
    RUI_XING_COFFE_ZC(21, "\u745e\u5e78\u5496\u5561\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    QB(22, "Q\u5e01", PurchaseSpuTypeEnum.ZC),
    CLOUD_BAI_DU_VIP(24, "\u767e\u5ea6\u4e91\u76d8\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    WANG_YI_YUN_VIP(25, "\u7f51\u6613\u4e91\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    TEN_XUN_VIDEO_VIP(26, "\u817e\u8baf\u89c6\u9891\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    NAI_XUE_ZC(23, "\u5948\u96ea\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    BI_LI_BI_LI_VIP(27, "\u54d4\u54e9\u54d4\u54e9\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    MANG_GUO_TV_VIP(28, "\u8292\u679c\u79fb\u52a8\u5f71\u89c6\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    XI_MA_LA_YA_VIP(29, "\u559c\u9a6c\u62c9\u96c5\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    WX_RED_PACKET(30, "\u5fae\u4fe1\u7ea2\u5305", PurchaseSpuTypeEnum.ZC),
    J_D_E_CARD(31, "\u4eac\u4e1cE\u5361", PurchaseSpuTypeEnum.ZC),
    HANG_LV_ZONG_HENG(32, "\u822a\u65c5\u7eb5\u6a2a\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    CNPC(33, "\u4e2d\u77f3\u6cb9", PurchaseSpuTypeEnum.ZC),
    SINOPEC(34, "\u4e2d\u77f3\u5316", PurchaseSpuTypeEnum.ZC),
    HONG_EN_ZC(35, "\u6d2a\u6069\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    WX_MORE_TRANSFER(36, "\u5fae\u4fe1\u5927\u989d\u8f6c\u8d26", PurchaseSpuTypeEnum.ZC),
    BANK_MORE_TRANSFER(37, "\u94f6\u884c\u5361\u5927\u989d\u8f6c\u8d26", PurchaseSpuTypeEnum.ZC),
    MEI_TUAN_COUPON(38, "\u7f8e\u56e2\u5916\u5356\u4ee3\u91d1\u5238", PurchaseSpuTypeEnum.ZC),
    MI_XUE_BING_CHENG(39, "\u871c\u96ea\u51b0\u57ce", PurchaseSpuTypeEnum.ZC),
    TU_HU_COUPON(40, "\u9014\u864e\u6d17\u8f66\u5238", PurchaseSpuTypeEnum.ZC),
    GAO_DE_COUPON(41, "\u9ad8\u5fb7\u6253\u8f66\u5238", PurchaseSpuTypeEnum.ZC),
    WPS_VIP(42, "wps\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    MANG_GUO_QUAN_PING_VIP(43, "\u8292\u679c\u5168\u5c4f\u5f71\u89c6\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    DOU_YIN_COUPON(44, "\u6296\u97f3\u56e2\u8d2d\u5238", PurchaseSpuTypeEnum.ZC),
    GU_MING_COUPON(45, "\u53e4\u8317\u4ee3\u91d1\u5238", PurchaseSpuTypeEnum.ZC),
    QQ_READ_VIP(46, "\u817e\u8bafQQ\u9605\u8bfb\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    DIDI_QJ_RIDING(47, "\u6ef4\u6ef4\u9752\u6854\u9a91\u884c\u5361", PurchaseSpuTypeEnum.ZC),
    CAR_SER(48, "\u6c7d\u8f66\u670d\u52a1", PurchaseSpuTypeEnum.CAR_SER),
    E_LE_ME_VIP(49, "\u997f\u4e86\u4e48\u8d85\u7ea7\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    DOU_YIN_PAY_COUPON(50, "\u6296\u97f3\u652f\u4ed8\u5238", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    MEI_TUAN_PAY_COUPON(51, "\u7f8e\u56e2\u652f\u4ed8\u5238", PurchaseSpuTypeEnum.MOBILE_PAYMENT),
    ADVANCE_PAYMENT(52, "\u57ab\u8d44", PurchaseSpuTypeEnum.ADVANCE_PAYMENT),
    WX_COUPON_THIRD(53, "\u5fae\u4fe1\u7acb\u51cf\u91d1-\u4e09\u65b9", PurchaseSpuTypeEnum.ZC),
    XIAO_JU_ZC(54, "\u5c0f\u6854\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    XING_XING_ZC(55, "\u661f\u661f\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    ALIPAY_COUPON_THIRD(56, "\u652f\u4ed8\u5b9d\u7acb\u51cf\u91d1-\u4e09\u65b9", PurchaseSpuTypeEnum.ZC),
    SHUN_YI_CHONG_ZC(57, "\u987a\u6613\u5145\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    CHE_DIAN_DIAN_ZC(58, "\u8f66\u70b9\u70b9\u76f4\u5145", PurchaseSpuTypeEnum.ZC),
    XUN_LEI_VIP(59, "\u8fc5\u96f7\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    ZHI_HU_VIP(60, "\u77e5\u4e4e\u76d0\u9009\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    KEEP_VIP(61, "KEEP\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    LAN_REN_VIP(62, "\u61d2\u4eba\u7545\u542c\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    KU_GOU_VIP(63, "\u9177\u72d7\u97f3\u4e50\u4f1a\u5458", PurchaseSpuTypeEnum.ZC),
    HA_LUO_DAN_CHE(64, "\u54c8\u5570\u5355\u8f66", PurchaseSpuTypeEnum.ZC),
    CA_BOC_BANK_COINS(66, "\u4e2d\u603b\u884c\u6570\u5e01-\u521b\u8bc6", PurchaseSpuTypeEnum.ZC),
    ALIPAY_TRANSFER(65, "\u652f\u4ed8\u5b9d\u8f6c\u8d26", PurchaseSpuTypeEnum.ZC),
    DIDI_DAI_JIA_VOUCHER(67, "\u6ef4\u6ef4\u4ee3\u9a7e\u5238", PurchaseSpuTypeEnum.ZC),
    TUHU(68, "\u9014\u864e\u76f4\u51b2", PurchaseSpuTypeEnum.ZC),
    ZUO_YE_BANG(69, "\u4f5c\u4e1a\u5e2e", PurchaseSpuTypeEnum.ZC),
    KAI_SHU_JIANG_GU_SHI(70, "\u51ef\u53d4\u8bb2\u6545\u4e8b", PurchaseSpuTypeEnum.ZC),
    UNION_PAY_COUPON(71, "\u94f6\u8054\u652f\u4ed8\u52b5", PurchaseSpuTypeEnum.MOBILE_PAYMENT);

    private final Integer type;
    private final String desc;
    private final PurchaseSpuTypeEnum purchaseSpuType;
    private static final Map<Integer, SpuTypeEnum> ENUM_MAP;
    private static final Map<Integer, List<SpuTypeEnum>> PURCHASE_ENUM_MAP;
    private static final Map<Integer, Set<Integer>> PURCHASE_TYPE_MAP;

    public PurchaseSpuTypeEnum getPurchaseSpuType() {
        return this.purchaseSpuType;
    }

    public static SpuTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static List<SpuTypeEnum> getEnumByPurchaseSpuType(Integer purchaseSpuType) {
        List<SpuTypeEnum> spuTypeEnums = PURCHASE_ENUM_MAP.get(purchaseSpuType);
        if (spuTypeEnums == null) {
            return Collections.emptyList();
        }
        return spuTypeEnums;
    }

    public static Set<Integer> getByPurchaseSpuType(Integer purchaseSpuType) {
        Set<Integer> types = PURCHASE_TYPE_MAP.get(purchaseSpuType);
        if (types == null) {
            return Collections.emptySet();
        }
        return types;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private SpuTypeEnum(Integer type, String desc, PurchaseSpuTypeEnum purchaseSpuType) {
        this.type = type;
        this.desc = desc;
        this.purchaseSpuType = purchaseSpuType;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(SpuTypeEnum.values()).collect(Collectors.toMap(SpuTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
        PURCHASE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(SpuTypeEnum.values()).collect(Collectors.groupingBy(s -> s.getPurchaseSpuType().getType())));
        PURCHASE_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(SpuTypeEnum.values()).collect(Collectors.groupingBy(s -> s.getPurchaseSpuType().getType(), Collectors.mapping(SpuTypeEnum::getType, Collectors.toSet()))));
    }
}

