package cn.com.duiba.quanyi.goods.service.api.dto.order.supplier;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商订单-微信立减金扩展字段
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@Data
public class SupplierOrderWxCouponDto implements Serializable {

    private static final long serialVersionUID = 17011699942823302L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 创建批次的商户号
     */
    private String stockCreatorMchId;

    /**
     * 公众账号ID
     */
    private String appId;

    /**
     * openId
     */
    private String openId;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 微信返回的券ID
     */
    private String wxCouponId;

    /**
     * 可用结束时间(仅当入参为需要查询券详情时有值)
     */
    private Date availableEndTime;

    /**
     * 微信状态
     */
    private String wxStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 指定面额发券，面额，单位分
     */
    private Integer couponValue;

    /**
     * 指定面额发券，券门槛，单位分
     */
    private Integer couponMinimum;

    /**
     * 是否需要过期状态
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum#getCode()
     */
    private Integer needExpiredStatus;
}