package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.wx.WxCouponOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.wx.WxCouponOrderResult;

/**
 * 订单-微信立减金
 *
 * @author lizhi
 * @date 2023/8/9 10:12
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorWxCouponService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<WxCouponOrderCreateReq> dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    WxCouponOrderResult findOrderResult(String customerOrderNo);
}
