package cn.com.duiba.quanyi.goods.service.api.dto.car;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 汽车服务-门店
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@Data
public class CarSerStoreDto implements Serializable {
     
    private static final long serialVersionUID = 17228471405131600L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 省
     */
    private String storeProvince;

    /**
     * 市
     */
    private String storeCity;

    /**
     * 区
     */
    private String storeDistrict;

    /**
     * 详细地址
     */
    private String storeAddress;

    /**
     * 省-行政区划编码
     */
    private String provinceCode;

    /**
     * 市-行政区划编码
     */
    private String cityCode;

    /**
     * 区-行政区划编码
     */
    private String districtCode;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 维度
     */
    private String latitude;

    /**
     * 门店图片
     */
    private String storeImg;

    /**
     * 明细图片，英文逗号分隔
     */
    private String descImg;

    /**
     * 营业时间，格式：HH:mm-HH:mm
     */
    private String businessTime;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 门店状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.car.CarSerStoreStateEnum
     */
    private Integer storeState;

    /**
     * 平台返回的原始数据
     */
    private List<CarSerStoreRawDateDto> rawData;
}