package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 卡密关联记录
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Data
public class CardSecretAssociationTaskDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 采购单ID
     */
    private Long purchaseOrderId;

    /**
     * 创建人ID
     */
    private Long creatorId;

    /**
     * 创建人姓名
     */
    private String creatorName;

    /**
     * 生成的批次ID
     */
    private Long cardSecretBatchId;

    /**
     * 关联的需求ID
     */
    private Long demandId;

    /**
     * 关联的需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 交付形式
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.DeliveryMethodEnum
     */
    private Integer deliveryMethod;

    /**
     * 备注
     */
    private String remark;

    /**
     * 发起关联数量
     */
    private Long toLinkQty;

    /**
     * 已关联数量
     */
    private Long linkedQty;

    /**
     * 退回数量
     */
    private Long returnedQty;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.AssociationTaskStatusEnum
     */
    private Integer status;

    /**
     * 分配批次类型
     * 
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.AllocateTypeEnum
     */
    private Integer allocateType;

}
