package cn.com.duiba.quanyi.goods.service.api.dto.express;

import cn.com.duiba.quanyi.goods.service.api.enums.express.ExpressTrackStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * express track info dto
 *
 * @author wangguanhua
 */
@Data
public class ExpressTrackInfoDto implements Serializable {

    private static final long serialVersionUID = 4967765726071455804L;
    /**
     * 物流单号
     */
    private String expressNo;

    /**
     * 物流公司
     */
    private String expressCompany;

    /**
     * 物流状态
     *
     * @see ExpressTrackStatusEnum#getStatus()
     */
    private Integer expressTrackStatus;

    /**
     * 轨迹节点 list
     */
    private List<TrackNode> trackNodeList;

    /**
     * 轨迹节点
     *
     * @author wangguanhua
     */
    @Data
    public static class TrackNode implements Serializable {

        private static final long serialVersionUID = 1669284523389429323L;

        /**
         * 时间
         */
        private String time;

        /**
         * 描述
         */
        private String desc;

    }
}
