package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.wx;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2024/1/19 18:27
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxTransferCreateReq extends BaseOrderCreateExtReq {
    
    private static final long serialVersionUID = -4579056338049266054L;

    /**
     * 微信公众账号ID
     * 必填
     */
    private String appId;

    /**
     * 用户微信openId
     * 最大32位
     * 必填
     */
    private String openId;

    /**
     * 转账金额，单位：分
     * 必填
     */
    private Long amount;

    /**
     * 微信的转账备注
     * 必填
     */
    private String remark;

    /**
     * 用户真实姓名(选填，若传入用户真实姓名，将与微信实名认证的姓名进行校验，只有一致时才能转账到用户零钱)
     */
    private String realName;

    /**
     * 保单号
     */
    private String policyNo;
}
