package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/12/22 16:42
 */
@Data
public class OrderGrantResult implements Serializable {
    
    private static final long serialVersionUID = -3782070029939201299L;

    /**
     * 代金券id	 
     */
    private String couponId;

    /**
     * 卡密类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.CardSecretTypeEnum
     */
    private Integer cardSecretType;

    /**
     * 失效时间戳
     */
    private Long expireTime;
    /**
     * 卡密批次号
     */
    private Long cardSecretBatchId;

    /**
     * 劵码
     */
    private String couponCode;

    /**
     * 链接劵
     */
    private String linkCode;

    /**
     * 账号
     */
    private String accountNo;

    /**
     * 密码
     */
    private String accountPassword;

    /**
     * 是否需要拼接登录信息
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer needAddToken;

    /**
     * 快递公司编码
     */
    private String expressCompanyCode;

    /**
     * 快递公司名称
     */
    private String expressCompanyName;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * 汽车服务-核销券码
     */
    private String verificationCoupon;

    /**
     * 汽车服务-核销提示语
     */
    private String verificationTips;

    /**
     * 汽车服务-施工信息
     */
    private String constructionInfo;

    /**
     * 发放时间
     */
    private Long grantTime;

    /**
     * 有效期起始时间，毫秒数，1970.1.1开始的毫秒数
     * ● 商品为微信立减金/支付宝立减金时，为券的有效起始时间
     */
    private Long beginTime;
}
