package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 卡密采购单更新参数
 *
 * @author yangyukang
 * @date 2024-09-23
 */
@Data
public class CardSecretPurchaseOrderUpdateParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 采购单ID（必填）
     */
    private Long id;

    /**
     * 采购数量
     */
    private Long purchaseQuantity;

    /**
     * 备注
     */
    private String remark;

    /**
     * 批次生效时间
     */
    private Date effectiveTime;

    /**
     * 批次失效时间
     */
    private Date expirationTime;

    /**
     * 卡密使用说明（批次的cardSecretDesc字段）
     */
    private String cardSecretDesc;

    /**
     * 成本价，单位分，比如1元，数据存为100
     */
    private Integer costPrice;
}
