package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretAssociationReturnedRecordDetailDto;

/**
 * 卡密关联退回记录详情远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretAssociationReturnedRecordDetailService {

    /**
     * 更新卡密关联退回记录详情
     *
     * @param dto 卡密关联退回记录详情DTO
     * @return 更新数量
     */
    int update(CardSecretAssociationReturnedRecordDetailDto dto);

    /**
     * 插入卡密关联退回记录详情
     *
     * @param dto 卡密关联退回记录详情DTO
     * @return 主键ID
     */
    Long insert(CardSecretAssociationReturnedRecordDetailDto dto);

    /**
     * 根据ID查询卡密关联退回记录详情
     *
     * @param id 主键ID
     * @return 卡密关联退回记录详情DTO
     */
    CardSecretAssociationReturnedRecordDetailDto selectById(Long id);


    /**
     * 根据退回记录ID查询卡密关联退回记录详情列表
     *
     * @param returnedRecordId 退回记录ID
     * @return 卡密关联退回记录详情列表
     */
    List<CardSecretAssociationReturnedRecordDetailDto> selectByReturnedRecordId(Long returnedRecordId);

    /**
     * 根据关联任务ID查询卡密关联退回记录详情列表
     *
     * @param cardSecretAssociationTaskId 关联任务ID
     * @return 卡密关联退回记录详情列表
     */
    List<CardSecretAssociationReturnedRecordDetailDto> selectByCardSecretAssociationTaskId(Long cardSecretAssociationTaskId);

    /**
     * 根据批次ID查询卡密关联退回记录详情列表
     *
     * @param cardSecretBatchId 批次ID
     * @return 卡密关联退回记录详情列表
     */
    List<CardSecretAssociationReturnedRecordDetailDto> selectByCardSecretBatchId(Long cardSecretBatchId);

    /**
     * 根据卡密ID查询卡密关联退回记录详情列表
     *
     * @param cardSecretCouponId 卡密ID
     * @return 卡密关联退回记录详情列表
     */
    List<CardSecretAssociationReturnedRecordDetailDto> selectByCardSecretCouponId(Long cardSecretCouponId);

    /**
     * 根据卡券ID和退回记录ID查询卡密关联退回记录详情
     *
     * @param cardSecretCouponId 卡券ID
     * @param returnedRecordId   退回记录ID
     * @return 卡密关联退回记录详情
     */
    CardSecretAssociationReturnedRecordDetailDto selectByCardSecretCouponIdAndReturnedRecordId(Long cardSecretCouponId,
            Long returnedRecordId);

}

