package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.wx.WxCouponOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.wx.third.WxCouponThirdOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.wx.WxCouponOrderResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.wx.WxCouponThirdOrderResult;

/**
 * 订单-微信立减金三方
 *
 * @author wangguanhua
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorWxCouponThirdService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<WxCouponThirdOrderCreateReq> dto);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    WxCouponThirdOrderResult findOrderResult(String customerOrderNo);
}
