package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierOrderUnionPayCouponDto;
import cn.com.duiba.quanyi.goods.service.api.param.supplier.SupplierOrderUnionPayCouponSearchParam;
import java.util.List;

/**
 * 供应商订单-银联
 * @author kjj mybatis generator 
 * @date 2025-04-21
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderUnionPayCouponService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 供应商订单-银联集合
     */
    List<SupplierOrderUnionPayCouponDto> selectPage(SupplierOrderUnionPayCouponSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierOrderUnionPayCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 供应商订单-银联
     */
    SupplierOrderUnionPayCouponDto selectById(Long id);

    /**
     * 新增
     * @param dto 供应商订单-银联
     * @return 影响行数
     */
    int insert(SupplierOrderUnionPayCouponDto dto);

    /**
     * 更新
     * @param dto 供应商订单-银联
     * @return 影响行数
     */
    int update(SupplierOrderUnionPayCouponDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}