package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.supplier.SupplierOrderWxTransferDto;

import java.util.List;

/**
 * 供应商订单-微信到零钱扩展字段
 * @author lizhi
 * @date 2024/2/7 16:39
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderWxTransferService {

    /**
     * 根据子单号查询
     * @param subOrderNo 子订单号
     * @return 供应商订单-微信到零钱扩展字段
     */
    SupplierOrderWxTransferDto selectBySubOrderNo(String subOrderNo);

    /**
     * 根据订单号查询
     *
     * @param orderNo 订单号
     * @return 供应商订单-微信到零钱扩展字段
     */
    List<SupplierOrderWxTransferDto> selectByOrderNo(String orderNo);

    /**
     * 根据订单号批量查询
     *
     * @param orderNos 订单号
     * @return 供应商订单-微信到零钱扩展字段
     */
    List<SupplierOrderWxTransferDto> selectByOrderNos(List<String> orderNos);
}
