package cn.com.duiba.ratelimit.service.api.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 单个规则的详情
 * Created by guoyanfei .
 * 2018/7/30 .
 */
@Data
@NoArgsConstructor
public class RatelimitPolicyDto implements Serializable {

    private static final long serialVersionUID = -3806262154994507566L;

    private Long id;

    /**
     * 限流应用，多个英文“,”隔开
     */
    private String serviceIds;

    /**
     * 描述
     */
    private String remarks;

    /**
     * 失效类型 1永久不失效 2有效期失效
     * RatelimitPolicyExpireType
     */
    private Integer expireType;

    /**
     * 失效时间点
     */
    private Date expireTime;

    /**
     * 状态，1生效 2失效
     * RatelimitPolicyState
     */
    private Integer policyState;

    /**
     * 分组方式 1不分组 2分组
     * RatelimitPolicyGroupingType
     */
    private Integer groupingType;

    /**
     * 分组规则，目前只有用户分组和appid分组需要填写分组规则 json
     */
    private String groupingPattern;

    /**
     * 计数方式 json
     */
    private String countPattern;

    /**
     * 命中规则 json
     */
    private String hitPattern;

    /**
     * 触发限流时的操作，1要求验证手势，2跳转限流页面，3只计数不限流
     * RatelimitPolicyOperation
     */
    private Integer limitOperation;

    /**
     * 触发限流时跳转的模板，优先于limitOperation

     */
    private Long limitTpleId;

    /**
     * 是否记录限流日志，1是，2否
     * RatelimitPolicyRecordLog
     */
    private Integer recordLog;

    private Date gmtCreate;

    private Date gmtModified;
}
