package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 分组方式
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyGroupingPattern {

    COOKIE("Cookie"),
    IP("Ip"),
    PARAM_KEY("ParamKey");

    private String key;

    RatelimitPolicyGroupingPattern(String key) {
        this.key = key;
    }

    public String key() {
        return key;
    }

    public static RatelimitPolicyGroupingPattern get(String key) {
        for (RatelimitPolicyGroupingPattern item: RatelimitPolicyGroupingPattern.values()) {
            if (item.key().equals(key)) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
