package cn.com.duiba.ratelimit.service.api.dto;

import cn.com.duiba.ratelimit.service.api.enums.RatelimitRefreshIntervalEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 定制的限流规则Dto
 * Created by guoyanfei .
 * 2020/5/15 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RatelimitAppPathPolicyDto implements Serializable {

    private static final long serialVersionUID = -3187394471512391029L;

    /**
     * 限流规则id
     * update操作不能为null
     */
    private Long id;

    /**
     * 限流应用
     * create/update操作不能为null
     */
    private String serviceId;

    /**
     * 需要限流的path
     * 比如：/many/people/travel
     * create/update操作不能为null
     */
    private String path;

    /**
     * 时间窗口
     * {@link cn.com.duiba.ratelimit.service.api.enums.RatelimitRefreshIntervalEnum}
     * create/update操作不能为null
     */
    private Integer refreshInterval;

    /**
     * 限制请求数
     * create/update操作不能为null
     */
    private Integer limit;

    public void setRefreshInterval(Integer refreshInterval) {
        RatelimitRefreshIntervalEnum refreshIntervalEnum = RatelimitRefreshIntervalEnum.get(refreshInterval);
        this.refreshInterval = refreshIntervalEnum.value();
    }
}
