package cn.com.duiba.ratelimit.service.api.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@NoArgsConstructor
public class RatelimitPolicyPageResponseDto implements Serializable {

    private static final long serialVersionUID = 1779117620763445879L;

    private Long id;

    /**
     * 限流应用，多个英文“,”隔开
     */
    private String serviceIds;

    /**
     * 分组方式 1不分组 2分组
     * RatelimitPolicyGroupingType
     */
    private Integer groupingType;

    /**
     * 描述
     */
    private String remarks;

    /**
     * 失效类型 1永久不失效 2有效期失效
     * RatelimitPolicyExpireType
     */
    private Integer expireType;

    /**
     * 失效时间点
     */
    private Date expireTime;

    /**
     * 状态，1生效 2失效
     * RatelimitPolicyState
     */
    private Integer policyState;

    /**
     * 触发限流时的操作，1要求验证手势，2跳转限流页面，3只计数不限流
     * RatelimitPolicyOperation
     */
    private Integer limitOperation;

    /**
     * 是否记录限流日志，1是，2否
     * RatelimitPolicyRecordLog
     */
    private Integer recordLog;

    private Date gmtCreate;

    /**
     * 今日限流次数
     */
    private Integer todayLimitTimes;

    /**
     * 昨日限流次数
     */
    private Integer yesterdayLimitTimes;
}
