package cn.com.duiba.ratelimit.service.api.dto;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 反向代理条目
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode
public class ReverseProxyItemDto implements Serializable {

	private static final long serialVersionUID = -6019751363821528735L;

	/**
	 * 条目的分类，业务方指定，{itemId,itemType}组成唯一索引,此字段用于支持多个业务方共存
	 */
	private String itemType;

	/**
	 * 条目id，业务方指定，{itemId,itemType}组成唯一索引
	 */
	private Long itemId;

	/**
	 * 目标url，即需要被代理的url，比如 http://www.ad.com, 不要包含path(即使有也会被忽略)
	 */
	private String targetUrl;

	public ReverseProxyItemDto(String itemType, Long itemId) {
		this.itemType = itemType;
		this.itemId = itemId;
	}
}
