package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 限流服务的分组类型
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyGroupingType {

    NO_GROUPING(1, "不分组"),
    GROUPING(2, "分组");

    private int    value;
    private String desc;

    RatelimitPolicyGroupingType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RatelimitPolicyGroupingType get(int value) {
        for (RatelimitPolicyGroupingType item : RatelimitPolicyGroupingType.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
