package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 限流时间窗口可选枚举
 * Created by guoyanfei .
 * 2020/5/15 .
 */
public enum RatelimitRefreshIntervalEnum {

    VALUE_1(1, "1秒"),
    VALUE_5(5, "5秒"),
    VALUE_60(60, "1分钟"),
    VALUE_3600(3600, "1小时");

    private int    value;
    private String desc;

    RatelimitRefreshIntervalEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RatelimitRefreshIntervalEnum get(int value) {
        for (RatelimitRefreshIntervalEnum item : RatelimitRefreshIntervalEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RatelimitException("不支持的时间窗口!");
    }

}


