package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.bean.PagerResponse;
import cn.com.duiba.ratelimit.service.api.dto.CdnDomainDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCdnDomainService {

    /**
     * 查询所有云厂商的cdn域名
     *
     * @return cdn域名列表
     * @throws BizException 业务异常
     * @param domain 域名查询条件。模糊匹配，当domain为null时表示查询所有域名
     * @param pageIndex
     * @param pageSize
     */
    PagerResponse<CdnDomainDto> listCdnDomains(String domain, Integer pageIndex, Integer pageSize) throws BizException;

    /**
     * 通过ssl证书查询所有云厂商的cdn域名
     *
     * @return cdn域名详情列表
     * @throws BizException 业务异常
     * @param sslDomain ssl证书id
     */
    List<CdnDomainDto> listCdnDomainBySsl(String sslDomain) throws BizException;

}
