package cn.com.duiba.ratelimit.service.api.remoteservice;

import java.util.List;
import java.util.Set;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.dto.ReverseProxyInfoDto;
import cn.com.duiba.ratelimit.service.api.dto.ReverseProxyItemDto;

/**
 * 反向代理信息获取和设置接口
 * @author: huangwq
 */
@AdvancedFeignClient
public interface RemoteReverseProxyInfoService {

    /**
     * 获取反向代理信息，客户端首次调用时version传入-1，后续调用时需要传入前一次调用响应的ReverseProxyInfoDto.version，
     * 客户端拿到结果后需要判断返回的版本号和之前的是否一致，如果一致则重用之前的结果即可。如果客户端不缓存，每次传入-1即可
     * @param version
     * @return
     */
    ReverseProxyInfoDto getAllReverseProxyInfoByVersion(long version);

    /**
     * 设置需要反向代理的域名列表，注意域名不能包含星号，比如www.tuia.cn,
     * 注意：调用此方法会替换掉所有域名，每次调用时请传入全量域名列表，且size不能超过100个。
     * 此接口调用后需要30秒后才能在网关生效。
     * @param hosts
     */
    void replaceHosts(Set<String> hosts);

    /**
     * 增加或更新反向代理条目, 对应的表有个唯一索引{itemId,itemType}，内部会判断如果已有此条目，则更新此数据。
     * 注意：出于性能考虑，当反代条目总条数超过10000条时，调此接口会抛出异常。
     */
    void addOrModifyReverseProxyItems(List<ReverseProxyItemDto> reverseProxyItems) throws BizException;

    /**
     * 根据 itemType, itemId 删除对应的反向代理条目
     */
    void removeReverseProxyItems(String itemType, List<Long> itemIds);

}
