package cn.com.duiba.ratelimit.service.api.enums;

/**
 * 命中规则参数来源枚举
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyHitPattern {

    HOST("Host"),
    PATH("Path"),
    IP("Ip"),
    USER_AGENT("User-Agent"),
    ORIGIN("Origin"),
    REFERER("Referer"),
    REQUEST_HEADERS("Request-Headers"),
    COOKIE("Cookie"),
    QUERY_STRING_PARAMETERS("Query-String-Parameters"),
    PARAM("Param"),
    PARAM_KEY("ParamKey");

    private String key;

    RatelimitPolicyHitPattern(String key) {
        this.key = key;
    }

    public String key() {
        return key;
    }

    public static RatelimitPolicyHitPattern get(String key) {
        for (RatelimitPolicyHitPattern item : RatelimitPolicyHitPattern.values()) {
            if (item.key().equals(key)) {
                return item;
            }
        }

        return null;
    }
}
