package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.bean.PagerResponse;
import cn.com.duiba.ratelimit.service.api.dto.RatelimitPolicyDto;
import cn.com.duiba.ratelimit.service.api.dto.RatelimitPolicyPageRequestDto;
import cn.com.duiba.ratelimit.service.api.dto.RatelimitPolicyPageResponseDto;

/**
 * 用于管理后台
 * Created by guoyanfei .
 * 2018/7/27 .
 */
@AdvancedFeignClient
public interface RemoteRatelimitBackendService {

    /**
     * 管理员端查询限流规则的分页列表
     *
     * @param pagerRequest
     * @return
     */
    PagerResponse<RatelimitPolicyPageResponseDto> pagePolicy(RatelimitPolicyPageRequestDto pagerRequest);

    /**
     * 失效操作
     *
     * @param policyId
     * @return
     */
    Boolean invalidate(Long policyId);

    /**
     * 生效操作
     *
     * @param policyId
     * @return
     */
    Boolean validate(Long policyId);

    /**
     * 获取单个规则的详情
     *
     * @param policyId
     * @return
     */
    RatelimitPolicyDto getPolicy(Long policyId);

    /**
     * 保存
     *
     * @return
     */
    Boolean savePolicy(RatelimitPolicyDto dto);

    /**
     * 删除
     *
     * @param policyId
     */
    void delete(Long policyId);
}
