package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.dto.RatelimitAppPathPolicyDto;

/**
 * 限流定制服务接口
 */
@AdvancedFeignClient
public interface RemoteRatelimitCustomizedService {

    /**
     * 创建限流规则
     * 创建成功，返回规则id
     * @param dto {@link RatelimitAppPathPolicyDto}
     * @return 规则id
     */
    Long createPolicy(RatelimitAppPathPolicyDto dto) throws BizException;

    /**
     * 更新限流规则
     * @param dto {@link RatelimitAppPathPolicyDto}
     */
    void updatePolicy(RatelimitAppPathPolicyDto dto) throws BizException;

    /**
     * 生效操作
     * @param policyId
     */
    void makeValid(Long policyId);

    /**
     * 失效操作
     * @param policyId
     */
    void makeInvalid(Long policyId);

}
