package cn.com.duiba.ratelimit.service.api.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wrj
 * @date 2020/7/7
 */
@Data
@NoArgsConstructor
public class DomainStatusDTO implements Serializable {

    // 域名名称
    private String domain;

    // 模拟访问连通性，当为null时表示域名不存在
    private Boolean accessible;

    // dns解析
    private Boolean dns;

    // https证书，当为null时说明域名未启用https
    private Boolean https;

    // cdn域名加速https证书 当为null时说明未启用cdn域名加速
    private Boolean cdn;

    // icp备案
    private Boolean icp;

    /**
     * 告警开始时间，当accessible为false时，该字段不为null
     */
    private Date alertStartTime;

}
