package cn.com.duiba.ratelimit.service.api.dto;

import java.io.Serializable;

/**
 * 网关域名
 */
public class GatewayDomainDto implements Serializable {

    /**
     * 应用名
     */
    private String appName;

    /**
     * 域名列表,多个","隔开
     */
    private String hosts;

    /**
     * path
     */
    private String location;

    /**
     * 是否除去前缀
     */
    private Boolean stripPrefix;

    /**
     * 是否需要转发到zuul
     */
    private Boolean viaZuul;

    /**
     * 是否开启https强制跳转
     */
    private Boolean forceHttps = Boolean.FALSE;

    /**
     * 是否是第三方的域名（非公司管理备案的域名）
     */
    private Boolean thirdParty = Boolean.FALSE;

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getHosts() {
        return hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Boolean getStripPrefix() {
        return stripPrefix;
    }

    public void setStripPrefix(Boolean stripPrefix) {
        this.stripPrefix = stripPrefix;
    }

    public Boolean getViaZuul() {
        return viaZuul;
    }

    public void setViaZuul(Boolean viaZuul) {
        this.viaZuul = viaZuul;
    }

    public Boolean getForceHttps() {
        return forceHttps;
    }

    public void setForceHttps(Boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    public Boolean getThirdParty() {
        return thirdParty;
    }

    public void setThirdParty(Boolean thirdParty) {
        this.thirdParty = thirdParty;
    }
}
