package cn.com.duiba.ratelimit.service.api.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author wenqi.huang
 */
@NoArgsConstructor
@Data
public class ReverseProxyInfoDto implements Serializable {

	private static final long serialVersionUID = -6039751363821528735L;

	/**
	 * 版本号，客户端根据此版本号判断服务端信息有没有经过修改;如果客户端传入的版本号和服务端一致，则本类的其他字段不需要设置，客户端重用之前的设置即可。
	 */
	private long version;

	/**
	 * 需要反向代理的域名列表，必须严格匹配，域名不能包含星号。
	 */
	private Set<String> hosts;

	/**
	 * 反向代理条目列表
	 */
	private List<ReverseProxyItemDto> reverseProxyItemList;

	public ReverseProxyInfoDto(long version) {
		this.version = version;
	}
}
