package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 限流规则的生效状态
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyState {

    VALID(1, "生效"),
    INVALID(2, "失效");

    private int    value;
    private String desc;

    RatelimitPolicyState(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RatelimitPolicyState get(int value) {
        for (RatelimitPolicyState item : RatelimitPolicyState.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
