package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.dto.GatewayDomainDto;

/**
 * 网关域名相关接口
 */
@AdvancedFeignClient
public interface RemoteGatewayDomainService {

    /**
     * 添加域名
     * @param domain
     * @return
     * @throws BizException
     */
    public Boolean addDomain(GatewayDomainDto domain) throws BizException;

    /**
     * 删除域名
     * @param appName
     * @param domains
     * @return
     * @throws BizException
     */
    public Boolean delDomain(String appName, String domains) throws BizException;
}
