package cn.com.duiba.ratelimit.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.ratelimit.service.api.bean.PagerResponse;
import cn.com.duiba.ratelimit.service.api.dto.SslCertBizOwnerDto;
import cn.com.duiba.ratelimit.service.api.dto.SslCertDto;
import cn.com.duiba.ratelimit.service.api.dto.SslCertPageRequestDto;
import cn.com.duiba.ratelimit.service.api.dto.SslCertVersionDto;

import java.util.Date;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019年02月22日 14:10
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteSslCertService {

    SslCertVersionDto getAllSslCertByVersion(Integer version);

    PagerResponse<SslCertDto> pageSslCert(SslCertPageRequestDto sslCertPageRequestDto);

    void edit(SslCertDto sslCertWriteDto);

    void add(SslCertDto sslCertDto);

    Long addAndReturnId(SslCertDto sslCertDto);

    void delete(Long sslCertId);

    List<SslCertBizOwnerDto> getBizOwnerConfig();

    List<SslCertDto> findSoonExpireCert(Integer days);

    List<SslCertDto> selectExpireThanDay(Integer dayNum, Date date);

    SslCertDto findDtoById(Long sslCertId);

}
