package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * Created by xiaoxuda on 2017/4/20.
 */
public class SignOperatingDto implements Serializable {
    private static final long serialVersionUID = -2723825912878855697L;

    //自定义标题
    public static final String KEY_TITLE = "title";
    //自定义签到描述
    public static final String KEY_DESCRIPTION = "description";
    //特殊日期
    public static final String KEY_SPEC_DAY_REWARD = "specDayRw";

    private Long id;
    /**
     * 签到活动ID
     */
    private Long signActivityId;
    /**
     * 签到活动类型
     */
    private SignActivityTypeEnum signType;
    /**
     * 签到活动皮肤id
     */
    private Long signSkinId;

    private Long appId;
    /**
     * 额外信息,json结构,内容同SignActivityDto中的extra
     */
    private JSONObject extra;

    private Date gmtCreate;

    private Date gmtModified;


    public void putToExtra(String key, Object val) {
        if (extra == null) {
            extra = new JSONObject();
        }
        extra.put(key, val);
    }

    public void removeFromExtra(String key) {
        if (extra == null) {
            return;
        }
        extra.remove(key);
    }

    public Object getFromExtra(String key) {
        if (extra == null) {
            return null;
        }
        return extra.get(key);
    }

    /**
     * 提取签到规则信息
     * @return
     */
    public SignRuleConfigDto getSignRuleConfig() {
        if (extra == null) {
            return null;
        }
        SignRuleConfigDto signRule = extra.getObject(SignActivityDto.KEY_SIGNRULE, SignRuleConfigDto.class);
        if(signRule == null){
            signRule = new SignRuleConfigDto();
        }
        return signRule;
    }

    /**
     * 提取补签规则信息
     * @return
     */
    public ReSignRuleConfigDto getReSignRuleConfig() {
        if (extra == null) {
            return null;
        }
        ReSignRuleConfigDto reSignRuleConfig= extra.getObject(SignActivityDto.KEY_RE_SIGN_RULE, ReSignRuleConfigDto.class);
        if(reSignRuleConfig == null){
            reSignRuleConfig = new ReSignRuleConfigDto();
        }
        return reSignRuleConfig;
    }

    /**
     * 提取签到奖励配置
     * @return
     */
    public SignRewardConfigDto getSignRewardConfig(){
        if (extra == null) {
            return new SignRewardConfigDto();
        }
        SignRewardConfigDto rewardConfig = extra.getObject(SignActivityDto.KEY_REWARD_CONFIG, SignRewardConfigDto.class);
        if(rewardConfig == null){
            rewardConfig = new SignRewardConfigDto();
        }
        return rewardConfig;
    }

    /**
     * 提取特殊日期签到奖励规则
     * @return
     */
    public SignRewardRule4SpecDayDto getSignRewardRule4SpecDay(){
        if (extra == null) {
            return new SignRewardRule4SpecDayDto();
        }
        SignRewardRule4SpecDayDto rewardConfig = extra.getObject(SignOperatingDto.KEY_SPEC_DAY_REWARD,
                SignRewardRule4SpecDayDto.class);
        if(rewardConfig == null){
            rewardConfig = new SignRewardRule4SpecDayDto();
        }
        return rewardConfig;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSignActivityId() {
        return signActivityId;
    }

    public void setSignActivityId(Long signActivityId) {
        this.signActivityId = signActivityId;
    }

    public SignActivityTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignActivityTypeEnum signType) {
        this.signType = signType;
    }

    public Long getSignSkinId() {
        return signSkinId;
    }

    public void setSignSkinId(Long signSkinId) {
        this.signSkinId = signSkinId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public JSONObject getExtra() {
        return extra;
    }

    public void setExtra(JSONObject extra) {
        this.extra = extra;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SignOperatingDto that = (SignOperatingDto) o;
        return Objects.equals(signActivityId, that.signActivityId) &&
                signType == that.signType &&
                Objects.equals(appId, that.appId);
    }

    @Override
    public int hashCode() {

        return Objects.hash(signActivityId, signType, appId);
    }
}
