package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.signpet.WanderPetRecordTypeEnum;
import java.io.Serializable;
import java.util.Date;

/**
 * Created by Liugq on 2018/8/7.
 */
public class SignWanderRecordDto implements Serializable {
    private static final long serialVersionUID = -5088296230495546517L;

    /**
     * id
     **/
    private Long id;
    /**
     * 活动ID
     **/
    private Long actId;
    /**
     * 用户ID
     **/
    private Long consumerId;
    /**
     * 宠物标识
     **/
    private String petIdentifier;
    /**
     * 宠物名称
     **/
    private String petName;
    /**
     * 记录类型：1.到访 2.礼物
     **/
    private WanderPetRecordTypeEnum recordType;
    /**
     * 礼物发放插件ID（type=礼物时）
     **/
    private Long rewardPluginId;
    /**
     * 到访宠物吃的食物标识
     **/
    private String eatToyName;
    /**
     * 到访宠物玩的玩具标识
     **/
    private String playToyName;
    /**
     * 是否已读（领取） 0-否 1-是
     **/
    private Boolean acceted;
    /**
     * 宠物来访时间(礼物出现时间)
     **/
    private Date showTime;
    /**
     * 宠物离开时间
     **/
    private Date leftTime;
    /**
     * 是否已读 0-否 1-是
     **/
    private Boolean readStatus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActId() {
        return actId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPetIdentifier() {
        return petIdentifier;
    }

    public void setPetIdentifier(String petIdentifier) {
        this.petIdentifier = petIdentifier;
    }

    public String getPetName() {
        return petName;
    }

    public void setPetName(String petName) {
        this.petName = petName;
    }

    public WanderPetRecordTypeEnum getRecordType() {
        return recordType;
    }

    public void setRecordType(WanderPetRecordTypeEnum recordType) {
        this.recordType = recordType;
    }

    public Long getRewardPluginId() {
        return rewardPluginId;
    }

    public void setRewardPluginId(Long rewardPluginId) {
        this.rewardPluginId = rewardPluginId;
    }

    public String getEatToyName() {
        return eatToyName;
    }

    public void setEatToyName(String eatToyName) {
        this.eatToyName = eatToyName;
    }

    public String getPlayToyName() {
        return playToyName;
    }

    public void setPlayToyName(String playToyName) {
        this.playToyName = playToyName;
    }

    public Boolean getAcceted() {
        return acceted;
    }

    public void setAcceted(Boolean acceted) {
        this.acceted = acceted;
    }

    public Date getShowTime() {
        return showTime;
    }

    public void setShowTime(Date showTime) {
        this.showTime = showTime;
    }

    public Date getLeftTime() {
        return leftTime;
    }

    public void setLeftTime(Date leftTime) {
        this.leftTime = leftTime;
    }

    public Boolean getReadStatus() {
        return readStatus;
    }

    public void setReadStatus(Boolean readStatus) {
        this.readStatus = readStatus;
    }
}
