package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户签到信息
 * Created by xiaoxuda on 2017/6/5.
 */
public class SignInfoDto extends BaseDto implements Serializable {

    private static final long serialVersionUID = -3868872593660301324L;

    /**
     * 今日签到状态
     */
    private Boolean todaySigned = false;

    /**
     * 签到类型
     */
    private SignTypeEnum signType;

    /**
     * 周期内连续签到天数
     */
    private Integer continueDay;

    /**
     * 累计签到积分
     */
    private Integer totalCredits;

    /**
     * 今日奖励的总积分
     */
    private Integer credits = 0;
    /**
     * 今日奖励的积分明细
     */
    private JSONObject creditsRemark = new JSONObject();
    /**
     * 今日奖励的总活动次数
     */
    private Integer activityCount = 0;
    /**
     * 今日奖励的活动次数明细
     */
    private JSONObject countRemark = new JSONObject();

    /**
     * 明日签到可得积分
     */
    private Integer creditsTomorrow;

    /**
     * 明日签到可得抽奖次数
     */
    private Integer activityCountTomorrow;
    /**
     * 第一次签到的时间
     */
    private Date firstSignDate;
    /**
     * 连续签到的总天数
     */
    private Integer lastDays;
    /**
     * 实际签到的总天数
     */
    private Integer acmDay;
    /**
     * 今日是否有累积奖励
     */
    private Boolean hasAcmReward;
    /**
     * 周期内最大连续签到天数
     * @return
     */
    private Integer maxContinueDay;

    public Boolean getTodaySigned() {
        return todaySigned;
    }

    public void setTodaySigned(Boolean todaySigned) {
        this.todaySigned = todaySigned;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public Integer getContinueDay() {
        return continueDay;
    }

    public void setContinueDay(Integer continueDay) {
        this.continueDay = continueDay;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getCreditsTomorrow() {
        return creditsTomorrow;
    }

    public void setCreditsTomorrow(Integer creditsTomorrow) {
        this.creditsTomorrow = creditsTomorrow;
    }

    public Integer getActivityCount() {
        return activityCount;
    }

    public void setActivityCount(Integer activityCount) {
        this.activityCount = activityCount;
    }

    public Integer getActivityCountTomorrow() {
        return activityCountTomorrow;
    }

    public void setActivityCountTomorrow(Integer activityCountTomorrow) {
        this.activityCountTomorrow = activityCountTomorrow;
    }

    public Date getFirstSignDate() {
        return firstSignDate;
    }

    public void setFirstSignDate(Date firstSignDate) {
        this.firstSignDate = firstSignDate;
    }

    public Integer getLastDays() {
        return lastDays;
    }

    public void setLastDays(Integer lastDays) {
        this.lastDays = lastDays;
    }

    public Boolean getHasAcmReward() {
        return hasAcmReward;
    }

    public JSONObject getCreditsRemark() {
        return creditsRemark;
    }

    public void setCreditsRemark(JSONObject creditsRemark) {
        this.creditsRemark = creditsRemark;
    }

    public JSONObject getCountRemark() {
        return countRemark;
    }

    public void setCountRemark(JSONObject countRemark) {
        this.countRemark = countRemark;
    }

    public void setHasAcmReward(Boolean hasAcmReward) {
        this.hasAcmReward = hasAcmReward;
    }

    public Integer getAcmDay() {
        return acmDay;
    }

    public void setAcmDay(Integer acmDay) {
        this.acmDay = acmDay;
    }

    public Integer getTotalCredits() {
        return totalCredits;
    }

    public void setTotalCredits(Integer totalCredits) {
        this.totalCredits = totalCredits;
    }

    public Integer getMaxContinueDay() {
        return maxContinueDay;
    }

    public void setMaxContinueDay(Integer maxContinueDay) {
        this.maxContinueDay = maxContinueDay;
    }

    @Override
    public String toString() {
        return "SignInfoDto{" +
                "todaySigned=" + todaySigned +
                ", signType=" + signType +
                ", continueDay=" + continueDay +
                ", totalCredits=" + totalCredits +
                ", credits=" + credits +
                ", creditsRemark=" + creditsRemark +
                ", activityCount=" + activityCount +
                ", countRemark=" + countRemark +
                ", creditsTomorrow=" + creditsTomorrow +
                ", activityCountTomorrow=" + activityCountTomorrow +
                ", firstSignDate=" + firstSignDate +
                ", lastDays=" + lastDays +
                ", acmDay=" + acmDay +
                ", maxContinueDay=" + maxContinueDay +
                ", hasAcmReward=" + hasAcmReward +
                '}';
    }
}
