package cn.com.duiba.sign.center.api.remoteservice.signcontract;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignContractDto;

import java.util.List;

/**
 * @author liugq
 * @date created in 2018/6/5
 * @description:
 */
@AdvancedFeignClient
public interface RemoteSignContractService {

    /**
     * 插入操作
     * @param dto 数据表对应的实体类
     * @return
     */
    Long insert(SignContractDto dto);
    /**
     * 根据主键删除对应数据
     * @param id
     * @return
     */
    int delete(Long id);
    /**
     * 根据主键更新对应数据条目
     * @param dto
     * @return
     */
    int update(SignContractDto dto);

    /**
     * 根据主键查询对应数据条目
     * @param id
     * @return
     */
    SignContractDto find(Long id);

    /**
     * 分页查询
     * @param pageNo
     * @param pageSize
     * @return
     */
    @Deprecated
    List<SignContractDto> pageList(Integer pageNo, Integer pageSize);

    /**
     * 分页查询
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<SignContractDto> pageListQuery(Integer pageNo, Integer pageSize, String title);

    /**
     * 总数查询
     * @return
     */
    @Deprecated
    int countAll();

    /**
     * 总数查询
     * @return
     */
    int countByCondition(String title);


}
