package cn.com.duiba.sign.center.api.remoteservice.signrecord;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.api.bo.page.PageQuery;
import cn.com.duiba.sign.center.api.params.SignedUserQueryParam;
import cn.com.duiba.sign.center.api.params.SignedUserSaveParam;

import java.util.List;

/**
 * Created by fangdong on 2018/10/16
 */
@AdvancedFeignClient
public interface RemoteSignedUserService {

    /**
     * 保存
     * @param param 参数
     * @throws BizException
     */
    void save(SignedUserSaveParam param) throws BizException;

    /**
     * 昨天签到，今日未签到用户ids
     * @return uid list
     * @throws BizException
     */
    @Deprecated
    List<String> listUnsignedUids(SignedUserQueryParam param, cn.com.duiba.biz.tool.duiba.dto.page.PageQuery query) throws BizException;

    /**
     * 昨天签到，今日未签到用户ids
     * @return uid list
     * @throws BizException
     */
    List<String> listUnsignedUidsApi(SignedUserQueryParam param, PageQuery query) throws BizException;

    /**
     * 昨天签到，今天未签到用户ids
     * @return uid count
     * @throws BizException
     */
    Long countUnsignedUids(SignedUserQueryParam param) throws BizException;

    @Deprecated
    cn.com.duiba.biz.tool.duiba.dto.page.Page<String> pageUnsignedUids(SignedUserQueryParam param, cn.com.duiba.biz.tool.duiba.dto.page.PageQuery query) throws BizException;

    Page<String> pageUnsignedUidsApi(SignedUserQueryParam param, PageQuery query) throws BizException;

}
