package cn.com.duiba.sign.center.api.enums.signcontract;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2018/10/24.
 */
public enum  AmpifyCardStatusEnum {

    AMPIFY_CARD_STATUS_INIT(0, "初始化"),
    AMPIFY_CARD_STATUS_USABLE(1, "可使用"),
    AMPIFY_CARD_STATUS_USED(2, "已使用"),

    ;

    private String desc;
    private int code;

    AmpifyCardStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, AmpifyCardStatusEnum> typeMap = new HashMap<>();

    static {
        for (AmpifyCardStatusEnum typeEnum : values()) {
            typeMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     *
     * @param code
     * @return
     */
    public static AmpifyCardStatusEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
