package cn.com.duiba.sign.center.api.enums.creditssign;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2019/3/13.
 * 通用来源枚举
 */
public enum  OriginEnum {
    DUIBA(0, "兑吧"),
    DEVELOPER(1, "开发者");

    private static Map<Integer, OriginEnum> typeEnumMap = new HashMap<>();

    static {
        for (OriginEnum typeEnum : OriginEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }


    private Integer code;
    private String desc;


    OriginEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 通过code获取签到来源类型
     *
     * @param code
     * @return
     */
    public static OriginEnum getByCode(Integer code) {
        if (null == code){
            return null;
        }
        return typeEnumMap.get(code);
    }
}
