/**
 * Project Name:activity-center-api
 * File Name:SignConfigDto.java
 * Package Name:cn.com.duiba.activity.center.api.dto.sign
 * Date:2016年10月22日下午2:01:42
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 签到配置dto
 * Created by fangdong on 2018/06/13
 */
public class SignConfigDto implements Serializable {
    private static final long serialVersionUID = -2988907274131663143L;

    private Long id;

    private Long appId;
    /**
     * 签到类型
     */
    private SignTypeEnum signType;

    /**
     * 签到积分奖励规则 逗号分隔 如2, 4, 6, 第一天奖励2分, 第二天奖励4分...以此类推
     */
    private String signCredits;

    /**
     * 签到积分奖励规则
     */
    private List<Integer> signCreditsList;

    /**
     * 此开关还没有使用
     */
    private Integer switches;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public void setSignCreditsList(List<Integer> signCreditsList) {
        this.signCreditsList = signCreditsList;
    }

    public List<Integer> getSignCreditsList() {
        return signCreditsList;
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }

    public String getSignCredits() {
        return signCredits;
    }

    public void setSignCredits(String signCredits) {
        this.signCredits = signCredits;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "SignConfigDto{" +
                "id=" + id +
                ", appId=" + appId +
                ", signType=" + signType +
                ", signCredits='" + signCredits + '\'' +
                ", signCreditsList=" + signCreditsList +
                ", switches=" + switches +
                '}';
    }
}

